// -*-C++-*-
//      unixtimer.h:
//              UnixTimer Object Definition
//              
//      12 Jun 1998  Seiji Tada, HSTD MST R&D, HP Japan
//
#ifndef _UNIX_TIMER_H
#define _UNIX_TIMER_H
#include <sys/time.h>

class UnixTimer {
public:
    UnixTimer ();
    UnixTimer (const UnixTimer & aTimer);
    ~UnixTimer ();
    void start ();
    void stop ();
    void reset ();
    double read ();

    UnixTimer & operator= (const UnixTimer & aTimer);
private:
    typedef enum {MSTFalse = 0, MSTTrue = 1} MSTBoolean;
    struct timeval      mStartTime;
    struct timeval      mStopTime;
    MSTBoolean          mIsStopped;
};

#endif /* _MST_TIMER_H */

extern UnixTimer aTimer;
